/*:
 * @target MZ
 * @plugindesc 画面の左半分をクリックするとESCキー、右半分をクリックするとEnterキーを押した扱いにするプラグイン
 * @command activateVirtualKeys
 * @text Activate Virtual Keys
 * @desc 仮想キーを有効にします
 * @command deactivateVirtualKeys
 * @text Deactivate Virtual Keys
 * @desc 仮想キーを無効にします
 */

(() => {
    let virtualKeysActive = false;

    const activateVirtualKeys = () => {
        if (virtualKeysActive) return;
        virtualKeysActive = true;

        const onClick = (event) => {
            const screenWidth = window.innerWidth;
            const x = event.clientX || event.touches[0].clientX;

            if (x < screenWidth / 2) {
                // 左半分をクリックするとESCキーを押した扱いにする
                Input._currentState['escape'] = true;
                setTimeout(() => Input._currentState['escape'] = false, 100);
            } else {
                // 右半分をクリックするとEnterキーを押した扱いにする
                Input._currentState['ok'] = true;
                setTimeout(() => Input._currentState['ok'] = false, 100);
            }
        };

        document.addEventListener('mousedown', onClick);
        document.addEventListener('touchstart', onClick);

        // Clean up function
        activateVirtualKeys._cleanup = () => {
            document.removeEventListener('mousedown', onClick);
            document.removeEventListener('touchstart', onClick);
            virtualKeysActive = false;
        };
    };

    const deactivateVirtualKeys = () => {
        if (activateVirtualKeys._cleanup) {
            activateVirtualKeys._cleanup();
        }
    };

    PluginManager.registerCommand('VirtualKeys', 'activateVirtualKeys', activateVirtualKeys);
    PluginManager.registerCommand('VirtualKeys', 'deactivateVirtualKeys', deactivateVirtualKeys);
})();